import { Player } from "@minecraft/server";
import { showConfigUI, updateConfig, getCurrentConfig } from "./config";
import { tryGetToken, testConfig } from "./bond";
export default function scriptEventHandler(event) {
    if (scriptIDDictionary[event.id]) {
        scriptIDDictionary[event.id](event);
    } else {
        let warning = `§4ScriptEvent ${event.id} is invalid!`;
        if (event.sourceEntity && event.sourceEntity instanceof Player) {
            let player = event.sourceEntity;
            player.sendMessage(warning);
        }
    }
}
async function connectionTest(player) {
    let response = await testConfig();
    switch(response){
        case "Sucess":
            player.sendMessage("§aConnection Test Suceeded.");
            break;
        case "Invalid IP":
            player.sendMessage("§cThe Device could not be reached. The Local Address is likely invalid.");
            break;
        case "Invalid Token":
            player.sendMessage("§cAccess was denied. Please provide a valid access token.");
            break;
        default:
            player.sendMessage("Unknown Error: HTTP Error " + response);
            break;
    }
}
const scriptIDDictionary = {
    "fan:config": async function(event) {
        if (event.sourceEntity === undefined && !(event.sourceEntity instanceof Player)) return;
        let player = event.sourceEntity;
        let newConfig = await showConfigUI(player);
        if (newConfig != undefined) {
            updateConfig(newConfig);
        }
    },
    "fan:automatic_setup": async function(event) {
        if (event.sourceEntity === undefined && !(event.sourceEntity instanceof Player)) return;
        let player = event.sourceEntity;
        player.sendMessage("Trying Automatic setup...");
        let conf = getCurrentConfig();
        let token = await tryGetToken();
        if (token === null) {
            player.sendMessage("§cFailed to connect to bond. Make sure that it is powered on and the provided IP is correct.");
            return;
        }
        if (token === undefined) {
            player.sendMessage("§cAutomatic Setup only works if the bond has been power cycled in the last ten minutes. Power Cycle the device and try again after a minute or two.");
            return;
        }
        updateConfig({
            address: conf.address,
            access_token: token
        });
        player.sendMessage("Automatic Setup Suceeded. Testing Connection...");
        connectionTest(player);
    },
    "fan:test": function(event) {
        if (event.sourceEntity === undefined && !(event.sourceEntity instanceof Player)) return;
        let player = event.sourceEntity;
        player.sendMessage("Starting Connection Test...");
        connectionTest(player);
    }
};
